/******************************************************************************
 *
 *		 E E P R O M   D R I V E R 
 *
 */
#include "eeprom.h"

uchar eeReadChar(uchar address) {
    EECON1bits.EEPGD = 0;
    EECON1bits.CFGS = 0;
    EEADR = address;
    EECON1bits.RD = 1;
    return EEDATA;
}

void eeWriteChar(uchar address, uchar dat) {
    EECON1bits.EEPGD = 0;
    EECON1bits.CFGS = 0;
    EEADR = address;
    EECON1bits.WREN = 1;
    PIR2bits.EEIF = 0;
    EEDATA = dat;
    INTCONbits.GIEH = 0;
    EECON2 = 0x55;
    EECON2 = 0xaa;
    EECON1bits.WR = 1;
    INTCONbits.GIEH = 1;
    while (PIR2bits.EEIF == 0);
    EECON1bits.WREN = 0;
}

float eeReadFloat(uchar address) {
    uchar i;

    union {
        uchar byte[4];
        float number;
    } data;

    EECON1bits.EEPGD = 0;
    EECON1bits.CFGS = 0;
    EEADR = address;
    for (i = 0; i < 4; i++) {
        EECON1bits.RD = 1;
        data.byte[i] = EEDATA;
        EEADR++;
    }
    return data.number;
}

void eeWriteFloat(uchar address, float dat) {
    uchar i;

    union {
        uchar byte[4];
        float number;
    } data;

    EECON1bits.EEPGD = 0;
    EECON1bits.CFGS = 0;
    data.number = dat;
    EEADR = address;
    EECON1bits.WREN = 1;
    for (i = 0; i < 4; i++) {
        PIR2bits.EEIF = 0;
        EEDATA = data.byte[i];
        INTCONbits.GIEH = 0;
        EECON2 = 0x55;
        EECON2 = 0xaa;
        EECON1bits.WR = 1;
        INTCONbits.GIEH = 1;
        while (PIR2bits.EEIF == 0);
        EEADR++;
    }
    EECON1bits.WREN = 0;
}